(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     81256,       1590]
NotebookOptionsPosition[     79345,       1529]
NotebookOutlinePosition[     79718,       1545]
CellTagsIndexPosition[     79675,       1542]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Houghton-Cassegrain with corrector at the prime focus", "Title",
 CellChangeTimes->{
  3.4601651768125*^9, {3.46016522934375*^9, 3.46016524503125*^9}, {
   3.46016550365625*^9, 3.460165507703125*^9}, {3.494853086453125*^9, 
   3.494853111328125*^9}, {3.653198892828125*^9, 3.653198901296875*^9}}],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["HoughtonCassegrainC",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["\[Sigma]",
           FontWeight->Bold], Cell["\<\
fraction of em in the first step of the project (Cassegrain with conic \
primary)\
\>"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]},
         {Cell["dcp",
           FontWeight->Bold], Cell["\<\
distance between the first surface of the corrector and the primary\
\>"]},
         {Cell["thick",
           FontWeight->Bold], Cell["thickness of the corrector"]},
         {Cell["di",
           FontWeight->Bold], Cell["distance between lenses"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["HoughtonCassegrainCInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell["HoughtonCassegrainC Examples", "Title"],

Cell["\<\
To use the HoughtonCassegrainC function you can either use directly the \
function HoughtonCassegrainC[f1,ft,ind,em,\[Sigma],diam,\[Theta],waves,dcp,\
thick,di] or use the interactive panel created by calling the function \
HoughtonCassegrainCInputPanel[]. It let\[CloseCurlyQuote]s you to choise \
input variables\[CloseCurlyQuote] values and then call the \
HoughtonCassegrainC function. Moreover, it helps to load examples from the \
saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Houghton Cassegrain F2-150-1500", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51872218", ",", "1", ",", 
        "1.51872218", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.52360494", ",", "1", ",", 
        "1.52360494", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51432242", ",", "1", ",", 
        "1.51432242", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "1500."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "300."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "208."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", "0.49"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "150"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.35"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcp", " ", "=", "12"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.65175566665625*^9, 3.651755682328125*^9}, {3.6530548795*^9, 
   3.653054919875*^9}, 3.653055232203125*^9, {3.65305533909375*^9, 
   3.65305534796875*^9}, {3.65305540346875*^9, 3.653055412265625*^9}, {
   3.653055477671875*^9, 3.653055478765625*^9}, {3.6530555143125*^9, 
   3.65305553178125*^9}, {3.653055592046875*^9, 3.65305560090625*^9}, 
   3.6530556506875*^9, {3.65305571078125*^9, 3.65305573509375*^9}, {
   3.653055784328125*^9, 3.6530558016875*^9}, {3.653055904328125*^9, 
   3.6530559049375*^9}, {3.653057676*^9, 3.6530576806875*^9}, {
   3.653057747546875*^9, 3.653057753453125*^9}, 3.653057790109375*^9, {
   3.65305784221875*^9, 3.653057858734375*^9}, 3.6530579099375*^9, {
   3.653057958203125*^9, 3.653057964609375*^9}, {3.653058024609375*^9, 
   3.653058040609375*^9}, {3.653058105640625*^9, 3.653058132609375*^9}, 
   3.65305816371875*^9, {3.653058198921875*^9, 3.653058199734375*^9}, 
   3.6530582473125*^9, 3.653058289453125*^9, 3.65305873634375*^9, {
   3.653058787640625*^9, 3.65305879290625*^9}, 3.65305883190625*^9, {
   3.65305887571875*^9, 3.653058925171875*^9}, {3.653061157875*^9, 
   3.6530611748125*^9}, {3.6530612169375*^9, 3.653061223203125*^9}, {
   3.653061260953125*^9, 3.65306127578125*^9}, {3.653061313390625*^9, 
   3.65306133271875*^9}, 3.65307000790625*^9, {3.6530700579375*^9, 
   3.653070109390625*^9}, {3.65309774078125*^9, 3.6530977420625*^9}, {
   3.65309786359375*^9, 3.653097877390625*^9}, {3.6530979235*^9, 
   3.65309792865625*^9}, {3.65309796375*^9, 3.653097988640625*^9}, {
   3.653098019359375*^9, 3.653098047796875*^9}, {3.653098088734375*^9, 
   3.653098124359375*^9}, {3.65309860415625*^9, 3.65309861275*^9}, {
   3.6530986595*^9, 3.65309866775*^9}, {3.65309894278125*^9, 
   3.653098969609375*^9}, {3.653099018828125*^9, 3.653099019796875*^9}, {
   3.653099053625*^9, 3.653099059859375*^9}, {3.65309929571875*^9, 
   3.6530993900625*^9}, 3.65309943828125*^9, {3.65309948046875*^9, 
   3.65309948978125*^9}, {3.65309953353125*^9, 3.65309953675*^9}, 
   3.65309959021875*^9, {3.6531001660625*^9, 3.653100181828125*^9}, {
   3.653100691859375*^9, 3.653100693515625*^9}, {3.6531008210625*^9, 
   3.653100869984375*^9}, {3.6531009025625*^9, 3.653100929515625*^9}, 
   3.6531009681875*^9, {3.653101039578125*^9, 3.653101044*^9}, {
   3.653101179390625*^9, 3.6531011846875*^9}, {3.653101347046875*^9, 
   3.653101350625*^9}, {3.653102035828125*^9, 3.65310204078125*^9}, {
   3.653102144875*^9, 3.653102156578125*^9}, 3.653102221953125*^9, {
   3.653102253015625*^9, 3.653102258296875*^9}, {3.6531227603125*^9, 
   3.65312276446875*^9}, 3.653122832*^9, {3.65312286671875*^9, 
   3.653122897796875*^9}, {3.653122940296875*^9, 3.6531229636875*^9}, {
   3.653123011328125*^9, 3.653123021171875*^9}, 3.653123090625*^9, {
   3.653123180140625*^9, 3.65312318234375*^9}, 3.653123224984375*^9, {
   3.653123453703125*^9, 3.6531234545*^9}, {3.65312349059375*^9, 
   3.6531234931875*^9}, 3.653123583890625*^9, 3.653123640828125*^9, {
   3.65312372846875*^9, 3.65312378315625*^9}, {3.653123975609375*^9, 
   3.653124009453125*^9}, {3.653124043609375*^9, 3.65312405159375*^9}, {
   3.653124098375*^9, 3.653124099609375*^9}, 3.653124909171875*^9, {
   3.653124944796875*^9, 3.65312494584375*^9}, 3.653124998140625*^9, {
   3.653125045546875*^9, 3.6531250484375*^9}, {3.6531251549375*^9, 
   3.653125177515625*^9}, 3.653125216734375*^9, {3.653199108890625*^9, 
   3.653199109171875*^9}, {3.6531991424375*^9, 3.653199158640625*^9}, {
   3.653208152546875*^9, 3.653208157515625*^9}, {3.6777343358558474`*^9, 
   3.6777343358558474`*^9}, {3.677735708597769*^9, 3.677735735890807*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"HoughtonCassegrainC", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
    "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.6778330937581277`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"HoughtonCassegrainC", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
    "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6778331006581373`*^9, 3.6778331022501397`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"HoughtonCassegrainC", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
    "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.677833269994375*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"HoughtonCassegrainC", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
    "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6778332758343835`*^9, 3.6778332765643845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"HoughtonCassegrainC", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
    "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.6778332814243913`*^9}],

Cell[CellGroupData[{

Cell["Houghton Cassegrain F2-150-1500", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51872218", ",", "1", ",", 
        "1.51872218", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.52360494", ",", "1", ",", 
        "1.52360494", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51432242", ",", "1", ",", 
        "1.51432242", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "1500."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "300."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "208."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", "0.49"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "150"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.35"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fact", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcp", " ", "=", "65"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spess1", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spess2", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.65175566665625*^9, 3.651755682328125*^9}, {3.6530548795*^9, 
   3.653054919875*^9}, 3.653055232203125*^9, {3.65305533909375*^9, 
   3.65305534796875*^9}, {3.65305540346875*^9, 3.653055412265625*^9}, {
   3.653055477671875*^9, 3.653055478765625*^9}, {3.6530555143125*^9, 
   3.65305553178125*^9}, {3.653055592046875*^9, 3.65305560090625*^9}, 
   3.6530556506875*^9, {3.65305571078125*^9, 3.65305573509375*^9}, {
   3.653055784328125*^9, 3.6530558016875*^9}, {3.653055904328125*^9, 
   3.6530559049375*^9}, {3.653057676*^9, 3.6530576806875*^9}, {
   3.653057747546875*^9, 3.653057753453125*^9}, 3.653057790109375*^9, {
   3.65305784221875*^9, 3.653057858734375*^9}, 3.6530579099375*^9, {
   3.653057958203125*^9, 3.653057964609375*^9}, {3.653058024609375*^9, 
   3.653058040609375*^9}, {3.653058105640625*^9, 3.653058132609375*^9}, 
   3.65305816371875*^9, {3.653058198921875*^9, 3.653058199734375*^9}, 
   3.6530582473125*^9, 3.653058289453125*^9, 3.65305873634375*^9, {
   3.653058787640625*^9, 3.65305879290625*^9}, 3.65305883190625*^9, {
   3.65305887571875*^9, 3.653058925171875*^9}, {3.653061157875*^9, 
   3.6530611748125*^9}, {3.6530612169375*^9, 3.653061223203125*^9}, {
   3.653061260953125*^9, 3.65306127578125*^9}, {3.653061313390625*^9, 
   3.65306133271875*^9}, 3.65307000790625*^9, {3.6530700579375*^9, 
   3.653070109390625*^9}, {3.65309774078125*^9, 3.6530977420625*^9}, {
   3.65309786359375*^9, 3.653097877390625*^9}, {3.6530979235*^9, 
   3.65309792865625*^9}, {3.65309796375*^9, 3.653097988640625*^9}, {
   3.653098019359375*^9, 3.653098047796875*^9}, {3.653098088734375*^9, 
   3.653098124359375*^9}, {3.65309860415625*^9, 3.65309861275*^9}, {
   3.6530986595*^9, 3.65309866775*^9}, {3.65309894278125*^9, 
   3.653098969609375*^9}, {3.653099018828125*^9, 3.653099019796875*^9}, {
   3.653099053625*^9, 3.653099059859375*^9}, {3.65309929571875*^9, 
   3.6530993900625*^9}, 3.65309943828125*^9, {3.65309948046875*^9, 
   3.65309948978125*^9}, {3.65309953353125*^9, 3.65309953675*^9}, 
   3.65309959021875*^9, {3.6531001660625*^9, 3.653100181828125*^9}, {
   3.653100691859375*^9, 3.653100693515625*^9}, {3.6531008210625*^9, 
   3.653100869984375*^9}, {3.6531009025625*^9, 3.653100929515625*^9}, 
   3.6531009681875*^9, {3.653101039578125*^9, 3.653101044*^9}, {
   3.653101179390625*^9, 3.6531011846875*^9}, {3.653101347046875*^9, 
   3.653101350625*^9}, {3.653102035828125*^9, 3.65310204078125*^9}, {
   3.653102144875*^9, 3.653102156578125*^9}, 3.653102221953125*^9, {
   3.653102253015625*^9, 3.653102258296875*^9}, {3.6531227603125*^9, 
   3.65312276446875*^9}, 3.653122832*^9, {3.65312286671875*^9, 
   3.653122897796875*^9}, {3.653122940296875*^9, 3.6531229636875*^9}, {
   3.653123011328125*^9, 3.653123021171875*^9}, 3.653123090625*^9, {
   3.653123180140625*^9, 3.65312318234375*^9}, 3.653123224984375*^9, {
   3.653123453703125*^9, 3.6531234545*^9}, {3.65312349059375*^9, 
   3.6531234931875*^9}, 3.653123583890625*^9, 3.653123640828125*^9, {
   3.65312372846875*^9, 3.65312378315625*^9}, {3.653123975609375*^9, 
   3.653124009453125*^9}, {3.653124043609375*^9, 3.65312405159375*^9}, {
   3.653124098375*^9, 3.653124099609375*^9}, 3.653124909171875*^9, {
   3.653124944796875*^9, 3.65312494584375*^9}, 3.653124998140625*^9, {
   3.653125045546875*^9, 3.6531250484375*^9}, {3.6531251549375*^9, 
   3.653125177515625*^9}, 3.653125216734375*^9, {3.65319924215625*^9, 
   3.6531992908125*^9}, {3.65319932490625*^9, 3.653199485109375*^9}, {
   3.653199526*^9, 3.65319977428125*^9}, {3.653208181421875*^9, 
   3.653208186296875*^9}, {3.677734335865847*^9, 3.677734335865847*^9}, {
   3.6778267753427777`*^9, 3.6778267764427795`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainC", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
   "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.65175566665625*^9, 3.651755682328125*^9}, {3.6530548795*^9, 
   3.653054919875*^9}, 3.653055232203125*^9, {3.65305533909375*^9, 
   3.65305534796875*^9}, {3.65305540346875*^9, 3.653055412265625*^9}, {
   3.653055477671875*^9, 3.653055478765625*^9}, {3.6530555143125*^9, 
   3.65305553178125*^9}, {3.653055592046875*^9, 3.65305560090625*^9}, 
   3.6530556506875*^9, {3.65305571078125*^9, 3.65305573509375*^9}, {
   3.653055784328125*^9, 3.6530558016875*^9}, {3.653055904328125*^9, 
   3.6530559049375*^9}, {3.653057676*^9, 3.6530576806875*^9}, {
   3.653057747546875*^9, 3.653057753453125*^9}, 3.653057790109375*^9, {
   3.65305784221875*^9, 3.653057858734375*^9}, 3.6530579099375*^9, {
   3.653057958203125*^9, 3.653057964609375*^9}, {3.653058024609375*^9, 
   3.653058040609375*^9}, {3.653058105640625*^9, 3.653058132609375*^9}, 
   3.65305816371875*^9, {3.653058198921875*^9, 3.653058199734375*^9}, 
   3.6530582473125*^9, 3.653058289453125*^9, 3.65305873634375*^9, {
   3.653058787640625*^9, 3.65305879290625*^9}, 3.65305883190625*^9, {
   3.65305887571875*^9, 3.653058925171875*^9}, {3.653061157875*^9, 
   3.6530611748125*^9}, {3.6530612169375*^9, 3.653061223203125*^9}, {
   3.653061260953125*^9, 3.65306127578125*^9}, {3.653061313390625*^9, 
   3.65306133271875*^9}, 3.65307000790625*^9, {3.6530700579375*^9, 
   3.653070109390625*^9}, {3.65309774078125*^9, 3.6530977420625*^9}, {
   3.65309786359375*^9, 3.653097877390625*^9}, {3.6530979235*^9, 
   3.65309792865625*^9}, {3.65309796375*^9, 3.653097988640625*^9}, {
   3.653098019359375*^9, 3.653098047796875*^9}, {3.653098088734375*^9, 
   3.653098124359375*^9}, {3.65309860415625*^9, 3.65309861275*^9}, {
   3.6530986595*^9, 3.65309866775*^9}, {3.65309894278125*^9, 
   3.653098969609375*^9}, {3.653099018828125*^9, 3.653099019796875*^9}, {
   3.653099053625*^9, 3.653099059859375*^9}, {3.65309929571875*^9, 
   3.6530993900625*^9}, 3.65309943828125*^9, {3.65309948046875*^9, 
   3.65309948978125*^9}, {3.65309953353125*^9, 3.65309953675*^9}, 
   3.65309959021875*^9, {3.6531001660625*^9, 3.653100181828125*^9}, {
   3.653100691859375*^9, 3.653100693515625*^9}, {3.6531008210625*^9, 
   3.653100869984375*^9}, {3.6531009025625*^9, 3.653100929515625*^9}, 
   3.6531009681875*^9, {3.653101039578125*^9, 3.653101044*^9}, {
   3.653101179390625*^9, 3.6531011846875*^9}, {3.653101347046875*^9, 
   3.653101350625*^9}, {3.653102035828125*^9, 3.65310204078125*^9}, {
   3.653102144875*^9, 3.653102156578125*^9}, 3.653102221953125*^9, {
   3.653102253015625*^9, 3.653102258296875*^9}, {3.6531227603125*^9, 
   3.65312276446875*^9}, 3.653122832*^9, {3.65312286671875*^9, 
   3.653122897796875*^9}, {3.653122940296875*^9, 3.6531229636875*^9}, {
   3.653123011328125*^9, 3.653123021171875*^9}, 3.653123090625*^9, {
   3.653123180140625*^9, 3.65312318234375*^9}, 3.653123224984375*^9, {
   3.653123453703125*^9, 3.6531234545*^9}, {3.65312349059375*^9, 
   3.6531234931875*^9}, 3.653123583890625*^9, 3.653123640828125*^9, {
   3.65312372846875*^9, 3.65312378315625*^9}, {3.653123975609375*^9, 
   3.653124009453125*^9}, {3.653124043609375*^9, 3.65312405159375*^9}, {
   3.653124098375*^9, 3.653124099609375*^9}, 3.653124909171875*^9, {
   3.653124944796875*^9, 3.65312494584375*^9}, 3.653124998140625*^9, {
   3.653125045546875*^9, 3.6531250484375*^9}, {3.6531251549375*^9, 
   3.653125177515625*^9}, 3.653125216734375*^9, {3.65319924215625*^9, 
   3.6531992908125*^9}, {3.65319932490625*^9, 3.653199485109375*^9}, {
   3.653199526*^9, 3.65319977428125*^9}, {3.653208181421875*^9, 
   3.653208186296875*^9}, {3.677734335865847*^9, 3.677734335865847*^9}, {
   3.6778267753427777`*^9, 3.6778267764427795`*^9}}],

Cell[CellGroupData[{

Cell["Houghton Cassegrain F2-2000 1\[Degree]", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51872218", ",", "1", ",", 
        "1.51872218", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.52360494", ",", "1", ",", 
        "1.52360494", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51432242", ",", "1", ",", 
        "1.51432242", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "400."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fact", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcp", " ", "=", "75"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spess1", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spess2", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.65175566665625*^9, 3.651755682328125*^9}, 3.65307075921875*^9, 
   3.653070845671875*^9, 3.65307088771875*^9, 3.65307094134375*^9, {
   3.653070990421875*^9, 3.653071000671875*^9}, 3.653071044453125*^9, 
   3.653071079671875*^9, 3.65307114475*^9, {3.653071179484375*^9, 
   3.65307121771875*^9}, 3.65307127590625*^9, {3.65307131703125*^9, 
   3.653071330328125*^9}, {3.653071366421875*^9, 3.653071393984375*^9}, {
   3.653071441828125*^9, 3.65307145484375*^9}, {3.653102715625*^9, 
   3.65310271634375*^9}, 3.653102768453125*^9, {3.653102801109375*^9, 
   3.65310281434375*^9}, 3.653102909078125*^9, {3.6531029508125*^9, 
   3.65310295134375*^9}, {3.653102995*^9, 3.65310302175*^9}, {
   3.653103060296875*^9, 3.65310306721875*^9}, 3.653103121125*^9, {
   3.653103162953125*^9, 3.65310319403125*^9}, {3.65310325403125*^9, 
   3.653103263078125*^9}, {3.6531037091875*^9, 3.653103729109375*^9}, 
   3.653103843625*^9, 3.653104067*^9, 3.65310416240625*^9, {
   3.65310420521875*^9, 3.653104206296875*^9}, {3.6531042424375*^9, 
   3.653104275390625*^9}, {3.653104361171875*^9, 3.6531043794375*^9}, {
   3.653104522390625*^9, 3.6531045314375*^9}, {3.653105083046875*^9, 
   3.653105087109375*^9}, {3.65310511771875*^9, 3.65310512128125*^9}, {
   3.6531055810625*^9, 3.653105694734375*^9}, {3.65310572921875*^9, 
   3.653105768234375*^9}, {3.65310579884375*^9, 3.653105811078125*^9}, {
   3.65310584390625*^9, 3.653105858390625*^9}, {3.653105900296875*^9, 
   3.65310590715625*^9}, {3.6531059384375*^9, 3.653105976953125*^9}, {
   3.653106015046875*^9, 3.653106137453125*^9}, {3.6531061685625*^9, 
   3.653106309078125*^9}, {3.653106342359375*^9, 3.65310637928125*^9}, {
   3.653106493109375*^9, 3.6531065056875*^9}, {3.6531065548125*^9, 
   3.653106563078125*^9}, 3.653106602578125*^9, {3.653107062328125*^9, 
   3.65310707946875*^9}, {3.65310715271875*^9, 3.65310717271875*^9}, {
   3.653107226625*^9, 3.6531072388125*^9}, {3.653107281078125*^9, 
   3.6531072989375*^9}, 3.653107334078125*^9, {3.653107364671875*^9, 
   3.653107470421875*^9}, 3.65310751090625*^9, 3.653107542015625*^9, {
   3.6531075891875*^9, 3.653107590140625*^9}, {3.653107624359375*^9, 
   3.65310762984375*^9}, {3.6531076805*^9, 3.653107697671875*^9}, {
   3.6531077835625*^9, 3.653108061640625*^9}, {3.6531081028125*^9, 
   3.6531081075625*^9}, {3.65310814415625*^9, 3.653108203453125*^9}, {
   3.653108233640625*^9, 3.65310839165625*^9}, {3.653108460765625*^9, 
   3.65310850746875*^9}, {3.653126121734375*^9, 3.6531261431875*^9}, {
   3.6531261916875*^9, 3.653126214125*^9}, 3.653126588625*^9, {
   3.653126620484375*^9, 3.65312662121875*^9}, {3.6531266578125*^9, 
   3.65312665840625*^9}, {3.653126704328125*^9, 3.65312673390625*^9}, 
   3.65312681078125*^9, {3.65312685053125*^9, 3.65312687346875*^9}, 
   3.653126919984375*^9, 3.65312697209375*^9, {3.65312703121875*^9, 
   3.6531270320625*^9}, {3.6531270795*^9, 3.653127110015625*^9}, 
   3.65312716140625*^9, 3.653127193515625*^9, {3.653127228578125*^9, 
   3.65312722921875*^9}, {3.653127297546875*^9, 3.6531273346875*^9}, {
   3.6531273715*^9, 3.653127383625*^9}, {3.653127606015625*^9, 
   3.653127640203125*^9}, {3.653127845203125*^9, 3.65312785659375*^9}, 
   3.65313063378125*^9, 3.653130963828125*^9, 3.65313100671875*^9, {
   3.65313105253125*^9, 3.653131072828125*^9}, {3.65313194784375*^9, 
   3.653131972515625*^9}, 3.653132011078125*^9, 3.653132425734375*^9, 
   3.65313279628125*^9, 3.653132863875*^9, {3.65313301090625*^9, 
   3.653133011421875*^9}, 3.6531450998179483`*^9, 3.653145132013878*^9, 
   3.6531451890024633`*^9, {3.653145304199463*^9, 3.6531453053132553`*^9}, {
   3.653145340151059*^9, 3.6531453410877275`*^9}, {3.653145434185008*^9, 
   3.653145468288288*^9}, {3.6531455064264402`*^9, 3.653145509245446*^9}, {
   3.653145542862382*^9, 3.65314554743964*^9}, {3.653145637882033*^9, 
   3.653145677934549*^9}, {3.6531457088225465`*^9, 3.6531457137730923`*^9}, {
   3.653187539671875*^9, 3.653187540171875*^9}, {3.653187584796875*^9, 
   3.653187585390625*^9}, {3.65318766775*^9, 3.653187686609375*^9}, {
   3.653188366828125*^9, 3.65318844559375*^9}, {3.653188495546875*^9, 
   3.653188501234375*^9}, 3.653188578234375*^9, 3.6531886185625*^9, 
   3.6531887298125*^9, {3.653188766375*^9, 3.653188845390625*^9}, {
   3.653188913625*^9, 3.653188918171875*^9}, {3.653189798265625*^9, 
   3.653189856046875*^9}, {3.65319979496875*^9, 3.65319981646875*^9}, {
   3.653208200171875*^9, 3.653208206796875*^9}, {3.677734335865847*^9, 
   3.677734335865847*^9}, 3.6778267786527824`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainC", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
   "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.65175566665625*^9, 3.651755682328125*^9}, 3.65307075921875*^9, 
   3.653070845671875*^9, 3.65307088771875*^9, 3.65307094134375*^9, {
   3.653070990421875*^9, 3.653071000671875*^9}, 3.653071044453125*^9, 
   3.653071079671875*^9, 3.65307114475*^9, {3.653071179484375*^9, 
   3.65307121771875*^9}, 3.65307127590625*^9, {3.65307131703125*^9, 
   3.653071330328125*^9}, {3.653071366421875*^9, 3.653071393984375*^9}, {
   3.653071441828125*^9, 3.65307145484375*^9}, {3.653102715625*^9, 
   3.65310271634375*^9}, 3.653102768453125*^9, {3.653102801109375*^9, 
   3.65310281434375*^9}, 3.653102909078125*^9, {3.6531029508125*^9, 
   3.65310295134375*^9}, {3.653102995*^9, 3.65310302175*^9}, {
   3.653103060296875*^9, 3.65310306721875*^9}, 3.653103121125*^9, {
   3.653103162953125*^9, 3.65310319403125*^9}, {3.65310325403125*^9, 
   3.653103263078125*^9}, {3.6531037091875*^9, 3.653103729109375*^9}, 
   3.653103843625*^9, 3.653104067*^9, 3.65310416240625*^9, {
   3.65310420521875*^9, 3.653104206296875*^9}, {3.6531042424375*^9, 
   3.653104275390625*^9}, {3.653104361171875*^9, 3.6531043794375*^9}, {
   3.653104522390625*^9, 3.6531045314375*^9}, {3.653105083046875*^9, 
   3.653105087109375*^9}, {3.65310511771875*^9, 3.65310512128125*^9}, {
   3.6531055810625*^9, 3.653105694734375*^9}, {3.65310572921875*^9, 
   3.653105768234375*^9}, {3.65310579884375*^9, 3.653105811078125*^9}, {
   3.65310584390625*^9, 3.653105858390625*^9}, {3.653105900296875*^9, 
   3.65310590715625*^9}, {3.6531059384375*^9, 3.653105976953125*^9}, {
   3.653106015046875*^9, 3.653106137453125*^9}, {3.6531061685625*^9, 
   3.653106309078125*^9}, {3.653106342359375*^9, 3.65310637928125*^9}, {
   3.653106493109375*^9, 3.6531065056875*^9}, {3.6531065548125*^9, 
   3.653106563078125*^9}, 3.653106602578125*^9, {3.653107062328125*^9, 
   3.65310707946875*^9}, {3.65310715271875*^9, 3.65310717271875*^9}, {
   3.653107226625*^9, 3.6531072388125*^9}, {3.653107281078125*^9, 
   3.6531072989375*^9}, 3.653107334078125*^9, {3.653107364671875*^9, 
   3.653107470421875*^9}, 3.65310751090625*^9, 3.653107542015625*^9, {
   3.6531075891875*^9, 3.653107590140625*^9}, {3.653107624359375*^9, 
   3.65310762984375*^9}, {3.6531076805*^9, 3.653107697671875*^9}, {
   3.6531077835625*^9, 3.653108061640625*^9}, {3.6531081028125*^9, 
   3.6531081075625*^9}, {3.65310814415625*^9, 3.653108203453125*^9}, {
   3.653108233640625*^9, 3.65310839165625*^9}, {3.653108460765625*^9, 
   3.65310850746875*^9}, {3.653126121734375*^9, 3.6531261431875*^9}, {
   3.6531261916875*^9, 3.653126214125*^9}, 3.653126588625*^9, {
   3.653126620484375*^9, 3.65312662121875*^9}, {3.6531266578125*^9, 
   3.65312665840625*^9}, {3.653126704328125*^9, 3.65312673390625*^9}, 
   3.65312681078125*^9, {3.65312685053125*^9, 3.65312687346875*^9}, 
   3.653126919984375*^9, 3.65312697209375*^9, {3.65312703121875*^9, 
   3.6531270320625*^9}, {3.6531270795*^9, 3.653127110015625*^9}, 
   3.65312716140625*^9, 3.653127193515625*^9, {3.653127228578125*^9, 
   3.65312722921875*^9}, {3.653127297546875*^9, 3.6531273346875*^9}, {
   3.6531273715*^9, 3.653127383625*^9}, {3.653127606015625*^9, 
   3.653127640203125*^9}, {3.653127845203125*^9, 3.65312785659375*^9}, 
   3.65313063378125*^9, 3.653130963828125*^9, 3.65313100671875*^9, {
   3.65313105253125*^9, 3.653131072828125*^9}, {3.65313194784375*^9, 
   3.653131972515625*^9}, 3.653132011078125*^9, 3.653132425734375*^9, 
   3.65313279628125*^9, 3.653132863875*^9, {3.65313301090625*^9, 
   3.653133011421875*^9}, 3.6531450998179483`*^9, 3.653145132013878*^9, 
   3.6531451890024633`*^9, {3.653145304199463*^9, 3.6531453053132553`*^9}, {
   3.653145340151059*^9, 3.6531453410877275`*^9}, {3.653145434185008*^9, 
   3.653145468288288*^9}, {3.6531455064264402`*^9, 3.653145509245446*^9}, {
   3.653145542862382*^9, 3.65314554743964*^9}, {3.653145637882033*^9, 
   3.653145677934549*^9}, {3.6531457088225465`*^9, 3.6531457137730923`*^9}, {
   3.653187539671875*^9, 3.653187540171875*^9}, {3.653187584796875*^9, 
   3.653187585390625*^9}, {3.65318766775*^9, 3.653187686609375*^9}, {
   3.653188366828125*^9, 3.65318844559375*^9}, {3.653188495546875*^9, 
   3.653188501234375*^9}, 3.653188578234375*^9, 3.6531886185625*^9, 
   3.6531887298125*^9, {3.653188766375*^9, 3.653188845390625*^9}, {
   3.653188913625*^9, 3.653188918171875*^9}, {3.653189798265625*^9, 
   3.653189856046875*^9}, {3.65319979496875*^9, 3.65319981646875*^9}, {
   3.653208200171875*^9, 3.653208206796875*^9}, {3.677734335865847*^9, 
   3.677734335865847*^9}, {3.6778267786527824`*^9, 3.677826779912784*^9}}],

Cell["Houghton Cassegrain F2-2000 1\[Degree] ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51872218", ",", "1", ",", 
        "1.51872218", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.52360494", ",", "1", ",", 
        "1.52360494", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51432242", ",", "1", ",", 
        "1.51432242", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "2000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "400."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fact", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcp", " ", "=", "25"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"spess1", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"spess2", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.494926747484375*^9, 3.494926932234375*^9}, {3.494926966296875*^9, 
   3.494927106203125*^9}, {3.494927141015625*^9, 3.494927162453125*^9}, {
   3.49492719446875*^9, 3.494927210578125*^9}, {3.49492724315625*^9, 
   3.49492726134375*^9}, 3.648698963826088*^9, {3.651755646265625*^9, 
   3.651755657640625*^9}, {3.651755690390625*^9, 3.651755691734375*^9}, 
   3.6531007316875*^9, 3.6531095910625*^9, 3.65310971334375*^9, {
   3.6531505382887287`*^9, 3.6531506543884068`*^9}, {3.6531506855956044`*^9, 
   3.6531507322538223`*^9}, {3.653150763993422*^9, 3.653150823016464*^9}, {
   3.653150853297002*^9, 3.653150854937172*^9}, {3.653150885745104*^9, 
   3.6531509055762444`*^9}, 3.653190673140625*^9, {3.65319071259375*^9, 
   3.65319072465625*^9}, {3.653199845625*^9, 3.653199869703125*^9}, {
   3.653208217859375*^9, 3.653208223375*^9}, {3.677734335875847*^9, 
   3.677734335875847*^9}, 3.6778267825927877`*^9}],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainC", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
   "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.494926747484375*^9, 3.494926932234375*^9}, {3.494926966296875*^9, 
   3.494927106203125*^9}, {3.494927141015625*^9, 3.494927162453125*^9}, {
   3.49492719446875*^9, 3.494927210578125*^9}, {3.49492724315625*^9, 
   3.49492726134375*^9}, 3.648698963826088*^9, {3.651755646265625*^9, 
   3.651755657640625*^9}, {3.651755690390625*^9, 3.651755691734375*^9}, 
   3.6531007316875*^9, 3.6531095910625*^9, 3.65310971334375*^9, {
   3.6531505382887287`*^9, 3.6531506543884068`*^9}, {3.6531506855956044`*^9, 
   3.6531507322538223`*^9}, {3.653150763993422*^9, 3.653150823016464*^9}, {
   3.653150853297002*^9, 3.653150854937172*^9}, {3.653150885745104*^9, 
   3.6531509055762444`*^9}, 3.653190673140625*^9, {3.65319071259375*^9, 
   3.65319072465625*^9}, {3.653199845625*^9, 3.653199869703125*^9}, {
   3.653208217859375*^9, 3.653208223375*^9}, {3.677734335875847*^9, 
   3.677734335875847*^9}, {3.6778267825927877`*^9, 3.677826783572789*^9}}],

Cell["Houghton Cassegrain F2-4000 1\[Degree] ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51872218", ",", "1", ",", 
        "1.51872218", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.52360494", ",", "1", ",", 
        "1.52360494", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "1.51432242", ",", "1", ",", 
        "1.51432242", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "4000."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f1", "=", "800."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "300."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Sigma]", " ", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "400"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.15"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"waves", "=", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fact", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dcp", " ", "=", "70"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"di", "=", "5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.494926747484375*^9, 3.494926932234375*^9}, {3.494926966296875*^9, 
   3.494927106203125*^9}, {3.494927141015625*^9, 3.494927162453125*^9}, {
   3.49492719446875*^9, 3.494927210578125*^9}, {3.49492724315625*^9, 
   3.49492726134375*^9}, 3.648698963826088*^9, {3.651755646265625*^9, 
   3.651755657640625*^9}, {3.651755690390625*^9, 3.651755691734375*^9}, 
   3.6531007316875*^9, 3.6531095910625*^9, 3.65310971334375*^9, {
   3.6531505382887287`*^9, 3.6531506543884068`*^9}, {3.6531506855956044`*^9, 
   3.6531507322538223`*^9}, {3.653150763993422*^9, 3.653150823016464*^9}, {
   3.653150853297002*^9, 3.653150854937172*^9}, {3.653150885745104*^9, 
   3.6531509055762444`*^9}, 3.653150954963385*^9, {3.653151005093075*^9, 
   3.6531510280053883`*^9}, {3.6531510587262597`*^9, 3.653151070519679*^9}, {
   3.653196697265625*^9, 3.65319693153125*^9}, {3.65319696578125*^9, 
   3.653196997390625*^9}, {3.653199902171875*^9, 3.653199928*^9}, {
   3.65320823175*^9, 3.653208236421875*^9}, {3.677734335875847*^9, 
   3.677734335875847*^9}, 3.677826785572792*^9, {3.677833748942049*^9, 
   3.6778337521620536`*^9}}],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainC", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "ind", ",", "em", ",", "\[Sigma]", ",", "diam", ",", 
   "\[Theta]", ",", "waves", ",", "dcp", ",", "thick", ",", "di"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.432191668273261*^9, 3.4321916718768606`*^9}, 
   3.45350422296875*^9, {3.460168137515625*^9, 3.4601681383125*^9}, {
   3.4601697923125*^9, 3.460169811421875*^9}, {3.460172198625*^9, 
   3.46017220471875*^9}, {3.46019843325*^9, 3.4601984445*^9}, {
   3.46019848646875*^9, 3.46019850696875*^9}, {3.460301322515625*^9, 
   3.460301347671875*^9}, 3.46198830696875*^9, {3.46208141450775*^9, 
   3.462081420179625*^9}, {3.4620815048515*^9, 3.4620815181015*^9}, {
   3.4620817211015*^9, 3.4620817259765*^9}, {3.46208273469525*^9, 
   3.462082735085875*^9}, {3.462083613164*^9, 3.462083614367125*^9}, {
   3.462083952460875*^9, 3.46208396194525*^9}, 3.462085082804625*^9, {
   3.4620855699765*^9, 3.46208560763275*^9}, {3.462154434609375*^9, 
   3.4621544443125*^9}, {3.462154487515625*^9, 3.462154504375*^9}, {
   3.46215463759375*^9, 3.462154748921875*^9}, {3.462154853546875*^9, 
   3.4621548636875*^9}, {3.462154899671875*^9, 3.462154900875*^9}, {
   3.462155383546875*^9, 3.462155392078125*^9}, {3.462155566984375*^9, 
   3.462155578859375*^9}, 3.4621556644375*^9, {3.462156688171875*^9, 
   3.462156699359375*^9}, {3.46217885040625*^9, 3.462178891765625*^9}, {
   3.462196665890625*^9, 3.462196673609375*^9}, {3.49455546796875*^9, 
   3.494555509296875*^9}, {3.494555604640625*^9, 3.494555740796875*^9}, 
   3.49455581459375*^9, {3.4945560191875*^9, 3.494556025640625*^9}, {
   3.494556090953125*^9, 3.49455609571875*^9}, {3.49455638353125*^9, 
   3.494556412234375*^9}, {3.4945564651875*^9, 3.49455647721875*^9}, 
   3.49455654084375*^9, {3.494556926296875*^9, 3.494556931921875*^9}, 
   3.49455713603125*^9, {3.494557182671875*^9, 3.494557191140625*^9}, 
   3.494562052296875*^9, {3.494562096796875*^9, 3.494562097328125*^9}, {
   3.494562172078125*^9, 3.494562225453125*^9}, {3.494562288140625*^9, 
   3.4945623313125*^9}, 3.494563394625*^9, 3.4945793944375*^9, 
   3.494579466*^9, {3.49458168534375*^9, 3.49458170834375*^9}, {
   3.49458177175*^9, 3.494581788421875*^9}, {3.494581824359375*^9, 
   3.494581869703125*^9}, {3.49458190828125*^9, 3.494581909859375*^9}, 
   3.49458197296875*^9, {3.494582280390625*^9, 3.494582340546875*^9}, {
   3.494582375328125*^9, 3.494582383984375*^9}, 3.4945824465*^9, {
   3.494657827234375*^9, 3.49465782871875*^9}, {3.4946581613125*^9, 
   3.49465817125*^9}, {3.49465835840625*^9, 3.4946583901875*^9}, {
   3.494658427296875*^9, 3.4946584798125*^9}, {3.49465852815625*^9, 
   3.49465853296875*^9}, {3.494658576109375*^9, 3.49465858959375*^9}, {
   3.49472820125*^9, 3.494728212609375*^9}, 3.494728273015625*^9, 
   3.494728307328125*^9, {3.494728346796875*^9, 3.494728352484375*^9}, {
   3.494822901515625*^9, 3.494822906890625*^9}, {3.494822968875*^9, 
   3.4948229693125*^9}, {3.49482361253125*^9, 3.49482362609375*^9}, {
   3.494823660921875*^9, 3.494823669515625*^9}, {3.49482372134375*^9, 
   3.494823722171875*^9}, {3.494823756171875*^9, 3.49482375815625*^9}, {
   3.4949012693809633`*^9, 3.4949012751789513`*^9}, 3.494901421206983*^9, {
   3.494926747484375*^9, 3.494926932234375*^9}, {3.494926966296875*^9, 
   3.494927106203125*^9}, {3.494927141015625*^9, 3.494927162453125*^9}, {
   3.49492719446875*^9, 3.494927210578125*^9}, {3.49492724315625*^9, 
   3.49492726134375*^9}, 3.648698963826088*^9, {3.651755646265625*^9, 
   3.651755657640625*^9}, {3.651755690390625*^9, 3.651755691734375*^9}, 
   3.6531007316875*^9, 3.6531095910625*^9, 3.65310971334375*^9, {
   3.6531505382887287`*^9, 3.6531506543884068`*^9}, {3.6531506855956044`*^9, 
   3.6531507322538223`*^9}, {3.653150763993422*^9, 3.653150823016464*^9}, {
   3.653150853297002*^9, 3.653150854937172*^9}, {3.653150885745104*^9, 
   3.6531509055762444`*^9}, 3.653150954963385*^9, {3.653151005093075*^9, 
   3.6531510280053883`*^9}, {3.6531510587262597`*^9, 3.653151070519679*^9}, {
   3.653196697265625*^9, 3.65319693153125*^9}, {3.65319696578125*^9, 
   3.653196997390625*^9}, {3.653199902171875*^9, 3.653199928*^9}, {
   3.65320823175*^9, 3.653208236421875*^9}, {3.677734335875847*^9, 
   3.677734335875847*^9}, {3.677826785572792*^9, 3.6778267866327934`*^9}}],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<HoughtonCassegrainC\>\"", "]"}]], "Input",
 CellChangeTimes->{3.677833314509438*^9}],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainC", "[", "]"}]], "Input",
 CellChangeTimes->{{3.67783332316945*^9, 3.677833324489452*^9}}],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"HoughtonCassegrainCInputPanel", "[", "]"}]], "Input",
 CellChangeTimes->{3.6778333279814568`*^9}]
},
CellGrouping->Manual,
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 302, 4, 71, "Title"],
Cell[CellGroupData[{
Cell[884, 28, 35, 0, 43, "Subsection"],
Cell[922, 30, 114, 2, 46, "Text"],
Cell[1039, 34, 2183, 58, 513, "Text"],
Cell[3225, 94, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5372, 152, 40, 0, 43, "Subsection"],
Cell[5415, 154, 255, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5707, 165, 40, 0, 43, "Subsection"],
Cell[5750, 167, 111, 2, 46, "Text"],
Cell[5864, 171, 3193, 83, 551, "Text"]
}, Open  ]],
Cell[9072, 257, 2296, 56, 473, "Text"],
Cell[11371, 315, 3465, 89, 849, "Text"],
Cell[14839, 406, 45, 0, 71, "Title"],
Cell[14887, 408, 524, 9, 94, "Text"],
Cell[15414, 419, 47, 0, 46, "Text"],
Cell[15464, 421, 8052, 138, 253, "Input"],
Cell[23519, 561, 546, 13, 55, "Input"],
Cell[24068, 576, 620, 13, 55, "Input"],
Cell[24691, 591, 619, 13, 55, "Input"],
Cell[25313, 606, 797, 16, 55, "Input"],
Cell[26113, 624, 890, 20, 55, "Input"],
Cell[CellGroupData[{
Cell[27028, 648, 47, 0, 46, "Text"],
Cell[27078, 650, 8191, 141, 297, "Input"]
}, Open  ]],
Cell[35284, 794, 6894, 101, 32, "Input"],
Cell[CellGroupData[{
Cell[42203, 899, 54, 0, 46, "Text"],
Cell[42260, 901, 9061, 153, 297, "Input"]
}, Open  ]],
Cell[51336, 1057, 7790, 113, 32, "Input"],
Cell[59129, 1172, 55, 0, 46, "Text"],
Cell[59187, 1174, 5444, 101, 297, "Input"],
Cell[64634, 1277, 4173, 61, 32, "Input"],
Cell[68810, 1340, 55, 0, 46, "Text"],
Cell[68868, 1342, 5616, 104, 275, "Input"],
Cell[74487, 1448, 4319, 63, 32, "Input"],
Cell[78809, 1513, 65, 0, 46, "Text"],
Cell[78877, 1515, 132, 2, 32, "Input"],
Cell[79012, 1519, 132, 2, 32, "Input"],
Cell[79147, 1523, 70, 0, 46, "Text"],
Cell[79220, 1525, 121, 2, 32, "Input"]
}
]
*)

